package gov.va.vinci.dart.biz;

import gov.va.vinci.dart.db.MedianWaitTimeDAO;

import java.sql.SQLException;
import java.util.List;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * Map the results of the Median Time calculation stored procedure (ws.GetMedianWaittimes) to this class.
 *
 */
@Entity
@Table(name = "medianwaittime", schema = "hib")
public class MedianWaitTime {

	public static final String REQ_TYPE_DART = "Dart Request";
	public static final String REQ_TYPE_OPERATIONAL = "Operational Request";
	public static final String REQ_TYPE_PREPARATORY = "Preparatory Request";
	
	
	//Metric			RequestorMedian		ReviewerMedian
	//Final NDS Review	0					0
	@Id
	@Column(name="metric")
	private String metric = "";	//review group name
	
	@Column(name="requestormedian")
	private float requestorMedian;

	@Column(name="reviewermedian")
	private float reviewerMedian;

	
	public MedianWaitTime() {}
	
	public MedianWaitTime( String metric, float requestorMedian, float reviewerMedian ) {
		this.metric = metric;
		this.requestorMedian = requestorMedian;
		this.reviewerMedian = reviewerMedian;
	}
	
	
	public String getMetric() {
		return metric;
	}

	public void setMetric(String metric) {
		this.metric = metric;
	}

	public float getRequestorMedian() {
		return requestorMedian;
	}

	public void setRequestorMedian(float requestorMedian) {
		this.requestorMedian = requestorMedian;
	}

	public float getReviewerMedian() {
		return reviewerMedian;
	}

	public void setReviewerMedian(float reviewerMedian) {
		this.reviewerMedian = reviewerMedian;
	}
	
	
	public static List<MedianWaitTime> retrieveMedianWaitTimes( final Request request ) throws SQLException {
		
		String requestTypeStr = "";
		if( DartRequest.class.isAssignableFrom(request.getClass()) ){
		    requestTypeStr = REQ_TYPE_DART;
		}else if( PreparatoryRequest.class.isAssignableFrom(request.getClass()) ){
		    requestTypeStr = REQ_TYPE_PREPARATORY;
		}
		else if( OperationalRequest.class.isAssignableFrom(request.getClass()) ){
			requestTypeStr = REQ_TYPE_OPERATIONAL;
		}
		return new MedianWaitTimeDAO(requestTypeStr).build();
	}
	
}
